<?php

namespace Comitium5\CommonWidgetsBundle\Twig;

use Comitium5\CommonWidgetsBundle\Utils\Assets\AssetsUtils;
use Comitium5\CommonWidgetsBundle\Utils\Assets\VideoUtils;

/**
 * Class AssetsExtension
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Twig
 */
class AssetsExtension extends \Twig_Extension
{
    /**
     * @var string
     */
    private $assetsUtils;

    /**
     * @var VideoUtils
     */
    private $videoUtils;

    /**
     * @var int
     */
    private $mimeTypeTimeout;

    /**
     * AssetsExtension constructor.
     * @param VideoUtils $videoUtils
     * @param AssetsUtils $assetsUtils
     * @param int $mimeTypeTimeout
     */
    public function __construct(
        VideoUtils $videoUtils,
        AssetsUtils $assetsUtils,
        $mimeTypeTimeout = 2
    ) {
        $this->videoUtils       = $videoUtils;
        $this->assetsUtils      = $assetsUtils;
        $this->mimeTypeTimeout  = $mimeTypeTimeout;
    }

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'cs_asset_url',
                [$this, 'buildAssetUrl']
            ),
            new \Twig_SimpleFunction(
                'cs_asset_image_url',
                [$this, 'buildAssetUrl']
            ),
            new \Twig_SimpleFunction(
                'cs_asset_video_url',
                [$this, 'buildAssetUrl']
            ),
            new \Twig_SimpleFunction(
                'cs_asset_video_is_iframe',
                [$this, 'isVideoIframe']
            ),
            new \Twig_SimpleFunction(
                'cs_asset_audio_render',
                [$this, 'audioRender'],
                ['is_safe' => ['html'],'needs_environment' => true]
            ),
            new \Twig_SimpleFunction(
                'cs_asset_video_render',
                [$this, 'videoRender'],
                ['is_safe' => ['html'],'needs_environment' => true]
            ),
            new \Twig_SimpleFunction(
                'cs_pro_src_set',
                [$this, 'generateProSrcSet']
            ),
            new \Twig_SimpleFunction(
                'cs_get_mime_type',
                [$this, 'getMimeType']
            ),
        ];
    }

    /**
     * @return array
     */
    public function getFilters()
    {
        return [];
    }

    /**
     * @param $url
     *
     * @return string
     */
    public function buildAssetUrl($url)
    {
        return $this->assetsUtils->buildAssetUrl($url);
    }

    /**
     * @param $embedCode
     *
     * @return bool
     */
    public function isVideoIframe($embedCode)
    {
        return $this->videoUtils->isIframe($embedCode);
    }

    /**
     * @param \Twig_Environment $environment
     * @param $url
     * @param string $class
     * @return string
     */
    public function audioRender(\Twig_Environment $environment, $url, $class = "")
    {
        return $environment->render(
            'Comitium5CommonWidgetsBundle:Assets:Audio/render_standard.html.twig', [
                'class' => $class,
                'url' => $url,
            ]
        );
    }

    /**
     * @param \Twig_Environment $environment
     * @param $url
     * @param string $class
     * @return mixed
     */
    public function videoRender(\Twig_Environment $environment, $url, $class = "")
    {
        return $environment->render(
            'Comitium5CommonWidgetsBundle:Assets:Video/render_standard.html.twig', [
                'class' => $class,
                'url' => $url,
            ]
        );
    }

    /**
     * @param array $asset
     * @param array $matchCrops
     * @return string
     */
    public function generateProSrcSet(array $asset, array $matchCrops = [])
    {
        return AssetsUtils::generateProSrcSet($asset,$matchCrops);
    }

    /**
     * @param $url
     * @return string
     */
    public function getMimeType($url)
    {
        return AssetsUtils::getMimeType(
            $url,
            $this->mimeTypeTimeout
        );
    }

    /**
     * Returns the name of the extension.
     *
     * @return string The extension name
     */
    public function getName()
    {
        return "comitium5_common_widgets_bundle_asset_twig_extension";
    }
}
