<?php

namespace Comitium5\CommonWidgetsBundle\Services;

use Comitium5\CommonWidgetsBundle\Cache\MemoryCacheInterface;

/**
 * Class GoogleApiService
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Services
 */
class GoogleApiService
{
    const API_URL = "https://www.googleapis.com";

    const API_VERSION = "v1";

    const CACHE_KEY = "google_short_url_%s";

    /**
     * @var string
     */
    private $apiKey;

    /**
     * @var MemoryCacheInterface
     */
    private $cache;

    /**
     * GoogleApiService constructor.
     * @param string $apiKey
     */
    public function __construct($apiKey, MemoryCacheInterface $cache)
    {
        $this->apiKey = $apiKey;
        $this->cache = $cache;
    }

    /**
     * @param $longUrl
     * @param bool|true $useCache
     *
     * @return mixed|null|string
     */
    public function generateShortedUrl($longUrl, $useCache = true)
    {
        if ($useCache === true) {
            $url = $this->cache->get(self::generateCacheKey($longUrl));

            if (!empty($url)) {
                return $url;
            }
        }

        $args = array(
            'longUrl' => $longUrl,
        );

        $ch = curl_init();
        $url = self::API_URL. DIRECTORY_SEPARATOR ."urlshortener". DIRECTORY_SEPARATOR .self::API_VERSION. DIRECTORY_SEPARATOR . "url?key=". $this->apiKey;

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-type:application/json'));
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($args));

        $response = curl_exec($ch);

        $data = json_decode($response, 1);

        $shortUrl = isset($data['id']) ? $data['id'] : $longUrl;

        if ($useCache === true) {
            $this->cache->set(self::generateCacheKey($longUrl), $shortUrl);
        }

        return $shortUrl;
    }

    /**
     * @param $url
     * @return string
     */
    public static function generateCacheKey($url)
    {
        return sprintf(self::CACHE_KEY, base64_encode($url));
    }
}