<?php

namespace Comitium5\CommonWidgetsBundle\Tests\Utils;

use Comitium5\CommonWidgetsBundle\Tests\TestCase;
use Comitium5\CommonWidgetsBundle\Utils\Dates\DateUtils;

/**
 * Class DatesTest
 *
 * phpunit Tests/Utils/DatesTest.php
 *
 * @author Oscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\ApiClientBundle\Tests\ApiClient
 */
class DatesTest extends TestCase
{
    /**
     * phpunit --filter testDate Tests/Utils/DatesTest.php
     */
    public function testDate()
    {
        $date = new \DateTime("2015-02-01 00:00:00");

        $this->assertEquals(DateUtils::date($date, "ca"), "1 febrer de 2015");
        $this->assertEquals(DateUtils::date($date, "es"), "1 de febrero de 2015");
        $this->assertEquals(DateUtils::date($date, "en"), "February 1, 2015");
    }

    /**
     * phpunit --filter testMonth Tests/Utils/DatesTest.php
     */
    public function testMonth()
    {
        $date = new \DateTime("2015-02-08 00:00:00");

        $this->assertEquals(DateUtils::month($date, "ca", false), "Febrer");
        $this->assertEquals(DateUtils::month($date, "es", false), "Febrero");
        $this->assertEquals(DateUtils::month($date, "en", false), "February");
        $this->assertEquals(DateUtils::month($date, "ca"), "de Febrer");
        $this->assertEquals(DateUtils::month($date, "es"), "de Febrero");
        $this->assertEquals(DateUtils::month($date, "en"), "of February");

        $date = new \DateTime("2015-10-01 00:00:00");

        $this->assertEquals(DateUtils::month($date, "ca"), "d' Octubre");
        $this->assertEquals(DateUtils::month($date, "es"), "de Octubre");
        $this->assertEquals(DateUtils::month($date, "en"), "of October");
    }

    /**
     * phpunit --filter testDay Tests/Utils/DatesTest.php
     */
    public function testDay()
    {
        $date = new \DateTime("2015-02-01 00:00:00");

        $this->assertEquals(DateUtils::day($date, "ca"), "Diumenge");
        $this->assertEquals(DateUtils::day($date, "es"), "Domingo");
        $this->assertEquals(DateUtils::day($date, "en"), "Sunday");
    }
}
