<?php

namespace Comitium5\CommonWidgetsBundle\Search;

use Elastica\Query;
use Elastica\Index;
use Elastica\Client;

/**
 * Class ElasticSearchMinimalProvider
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Search
 */
class ElasticSearchMinimalProvider
{
    /**
     * @var Index
     */
    private $index;

    /**
     * ElasticSearchClient constructor.
     * @param $host
     * @param $port
     * @param $index
     */
    public function __construct(
        $host,
        $port,
        $index
    ) {
        $client = new Client([
            "host" => $host,
            "port" => $port,
        ]);

        $this->index = $client->getIndex($index);
    }

    /**
     * @param Query $query
     * @param array $queryOptions
     * @return array
     */
    public function search(Query $query, $queryOptions = [])
    {
        $results = $this
            ->index
            ->search($query, $queryOptions);

        return ElasticResultParser::parser($results);
    }
}