<?php

namespace Comitium5\CommonWidgetsBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * This is the class that loads and manages your bundle configuration
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/extension.html}
 */
class Comitium5CommonWidgetsExtension extends Extension implements PrependExtensionInterface
{
    /**
     * @param ContainerBuilder $container
     */
    public function prepend(ContainerBuilder $container)
    {
        $bundles = $container->getParameter('kernel.bundles');

        if (isset($bundles["BeelabRecaptcha2Bundle"])) {

            $commonWidgetConfig = $container->getExtensionConfig("comitium5_common_widgets");

            if (!isset($commonWidgetConfig[0]["recaptcha_site_key"]) || !isset($commonWidgetConfig[0]["recaptcha_secret"])) {
                throw new \Exception("recaptcha_site_key and recaptcha_secret for common widget bundle must be configured" );
            }

            $config = [
                "site_key" => $commonWidgetConfig[0]["recaptcha_site_key"],
                "secret"   => $commonWidgetConfig[0]["recaptcha_secret"],
            ];

            $container->prependExtensionConfig("beelab_recaptcha2",$config);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();

        $configParams = $this->processConfiguration($configuration, $configs);

        foreach ($configParams as $key => $configParam) {
            $container->setParameter("comitium5_common_widgets.".$key, $configParam);
        }

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yml');
        $loader->load('utils.yml');
    }
}
