<?php

namespace Comitium5\CommonWidgetsBundle\Twig;

use Comitium5\CommonWidgetsBundle\Utils\Assets\AssetsUtils;
use Comitium5\CommonWidgetsBundle\Utils\Assets\VideoUtils;

/**
 * Class AssetsExtension
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Twig
 */
class AssetsExtension extends \Twig_Extension
{
    /**
     * @var string
     */
    private $assetsUtils;

    /**
     * @var VideoUtils
     */
    private $videoUtils;

    /**
     * @var \Twig_Environment
     */
    protected $environment;

    /**
     * @param VideoUtils  $videoUtils
     * @param AssetsUtils $assetsUtils
     */
    public function __construct(
        VideoUtils $videoUtils,
        AssetsUtils $assetsUtils

    ) {
        $this->videoUtils   = $videoUtils;
        $this->assetsUtils  = $assetsUtils;
    }

    /**
     * {@inheritDoc}
     */
    public function initRuntime(\Twig_Environment $environment)
    {
        $this->environment = $environment;
    }

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction('cs_asset_url', [$this, 'buildAssetUrl']),
            new \Twig_SimpleFunction('cs_asset_image_url', [$this, 'buildAssetUrl']),
            new \Twig_SimpleFunction('cs_asset_video_url', [$this, 'buildAssetUrl']),
            new \Twig_SimpleFunction('cs_asset_video_is_iframe', [$this, 'isVideoIframe']),
            new \Twig_SimpleFunction('cs_asset_audio_render', [$this, 'audioRender'], ['is_safe' => ['html']]),
            new \Twig_SimpleFunction('cs_asset_video_render', [$this, 'videoRender'], ['is_safe' => ['html']]),
            new \Twig_SimpleFunction('cs_pro_src_set', array($this, 'generateProSrcSet')),
            new \Twig_SimpleFunction('cs_get_mime_type', array($this, 'getMimeType')),
        ];
    }

    /**
     * @return array
     */
    public function getFilters()
    {
        return [];
    }

    /**
     * @param $url
     *
     * @return string
     */
    public function buildAssetUrl($url)
    {
        return $this->assetsUtils->buildAssetUrl($url);
    }

    /**
     * @param $embedCode
     *
     * @return bool
     */
    public function isVideoIframe($embedCode)
    {
        return $this->videoUtils->isIframe($embedCode);
    }

    /**
     * @param $class
     * @param $url
     *
     * @return string
     */
    public function audioRender($url, $class = "")
    {
        return $this->environment->render(
            'Comitium5CommonWidgetsBundle:Assets:Audio/render_standard.html.twig', [
                'class' => $class,
                'url' => $url,
            ]
        );
    }

    /**
     * @param $class
     * @param $url
     *
     * @return string
     */
    public function videoRender($url, $class = "")
    {
        return $this->environment->render(
            'Comitium5CommonWidgetsBundle:Assets:Video/render_standard.html.twig', [
                'class' => $class,
                'url' => $url,
            ]
        );
    }

    /**
     * @param array $asset
     * @param array $matchCrops
     * @return string
     */
    public function generateProSrcSet(array $asset, array $matchCrops = [])
    {
        return AssetsUtils::generateProSrcSet($asset,$matchCrops);
    }

    /**
     * @param $url
     * @return string
     */
    public function getMimeType($url)
    {
        return AssetsUtils::getMimeType($url);
    }

    /**
     * Returns the name of the extension.
     *
     * @return string The extension name
     */
    public function getName()
    {
        return "comitium5_common_widgets_bundle_asset_twig_extension";
    }
}
