<?php

namespace Comitium5\CommonWidgetsBundle\Twig;

use Comitium5\CommonWidgetsBundle\Utils\Dates\DateUtils;

/**
 * Class DateExtension
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Twig
 */
class DateExtension extends \Twig_Extension
{
    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction('cs_date', [$this, 'getDate']),
            new \Twig_SimpleFunction('cs_month', [$this, 'getMonth']),
            new \Twig_SimpleFunction('cs_day', [$this, 'getDay']),
        ];
    }

    /**
     * @return array
     */
    public function getFilters()
    {
        return [];
    }

    /**
     * @param $date
     * @param string $locale
     * @param null   $format
     *
     * @return string|void
     */
    public function getDate($date, $locale = "en", $format = null, $dateType = \IntlDateFormatter::LONG, $timeType = \IntlDateFormatter::NONE, $timezone = null, $calendar = \IntlDateFormatter::GREGORIAN)
    {
        $date = $this->buildDate($date);

        if ($date === null) {
            return;
        }

        return DateUtils::date($date, $locale, $format, $dateType, $timeType, $timezone, $calendar);
    }

    /**
     * @param $date
     * @param string $locale
     * @param bool   $prefix
     *
     * @return string|void
     */
    public function getMonth($date, $locale = "en", $prefix = null)
    {
        $date = $this->buildDate($date);

        if ($date === null) {
            return;
        }

        return DateUtils::month($date, $locale, $prefix);
    }

    /**
     * @param $date
     * @param string $locale
     *
     * @return string|void
     */
    public function getDay($date, $locale = "en")
    {
        $date = $this->buildDate($date);

        if ($date === null) {
            return;
        }

        return DateUtils::day($date, $locale);
    }

    /**
     * @param $date
     *
     * @return \DateTime|void
     */
    private function buildDate($date)
    {
        if (!$date instanceof \DateTime) {
            if (is_array($date)) {
                if (empty($date["date"])) {
                    return;
                }

                if (($date = new \DateTime($date["date"])) === false) {
                    return;
                }
            }

            if (is_string($date)) {
                if (($date = new \DateTime($date)) === false) {
                    return;
                }
            }
        }

        return $date;
    }

    /**
     * Returns the name of the extension.
     *
     * @return string The extension name
     */
    public function getName()
    {
        return "comitium5_common_widgets_bundle_date_twig_extension";
    }
}
