<?php

namespace Comitium5\CommonWidgetsBundle\Search;

use Elastica\Query;
use Elastica\Client;
use Elastica\ResultSet;
use Elastica\Search;

/**
 * Class ElasticSearchMinimalProvider
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Search
 */
class ElasticSearchMinimalProvider
{
    /**
     * @var Client
     */
    private $client;

    /**
     * ElasticSearchClient constructor.
     * @param array $parameters
     *
     * @throws \Exception
     */
    public function __construct(array $parameters)
    {
        if (!isset($parameters['host']) || !isset($parameters['port'])) {
            throw new \Exception("Error: Elastic parameters are missing");
        }

        $this->client = new Client([
            "host"      => $parameters['host'],
            "port"      => $parameters['port'],
            "username"  => $parameters['username'] ?? null,
            "password"  => $parameters['password'] ?? null,
            "transport" => $parameters['transport'] ?? null,
            "curl"      => $parameters['curl'] ?? null,
        ]);
    }

    /**
     * @param Query $query
     * @param $queryOptions
     * @param $index
     * @param null $type
     * @param bool $parseResults
     * @return array|ResultSet
     */
    public function search(
        Query $query,
        $queryOptions,
        $index,
        $type = null,
        $parseResults = true
    ) {
        $search = new Search($this->client);

        $search->addIndex($index);

        if ($type !== null) {
            if (is_array($type)) {
                foreach ($type as $typeValue) {
                    $search->addType($typeValue);
                }
            } elseif (is_string($type)) {
                $search->addType($type);
            }
        }

        $results = $search->search($query, $queryOptions);

        return $parseResults === true ?
            ElasticResultParser::parser($results) :
            $results
            ;
    }
}
