<?php

namespace Comitium5\CommonWidgetsBundle\Normalizers\Poll;

/**
 * Class PollNormalizer
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Normalizers\Poll
 */
class PollNormalizer
{
    /**
     * @param array $poll
     *
     * @return array
     */
    public static function normalize(array $poll)
    {
        $normalizedPoll = [
            'id'      => $poll['id'],
            'answers' => [],
        ];

        foreach ($poll['answers'] as $answer) {
            $normalizedPoll['answers'][] = [
                'votes' => $answer['votes'],
                'id'    => $answer['id'],
                'title' => $answer['answer'],
            ];
        }

        return $normalizedPoll;
    }
}
