<?php

namespace Comitium5\CommonWidgetsBundle\Tests\PayWall\ValueObject;

use Comitium5\CommonWidgetsBundle\Tests\PayWall\PayWallTestCase;

/**
 * Class PayWallTokenObjectTest
 *
 * @author Óscar Jimenez <oscar@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Tests\PayWall\ValueObject
 */
class PayWallTokenObjectTest extends PayWallTestCase
{
    /**
     * @test
     * @throws \ReflectionException
     */
    public function serialize()
    {
        $object = $this->payWallObject();

        $serializeObject = $object->serialize();

        $jsonStringExpected = json_encode([
            "objectId"                  => 1234,
            "objectType"                => 'articles',
            "objectSubscriptions"       => [
                ["id" => 100],
                ["id" => 200],
                ["id" => 300],
            ],
            "privateContentTemplate"    => 'paywall-private.html.twig',
            "privateContentData"        => ['id' => 1234, 'title' => 'foo'],
            "payWallTemplate"           => 'paywall-subscription.html.twig',
            "payWallTemplateData"       => ['locale' => 'en', 'title' => 'Subscribe!'],
            "cacheKeyPrefix"            => '__PAYWALL__',
            "cacheTTL"                  => 300,
            "cacheTTLSecondsToIncrease" => 120,
            "payWallOptions"            => [
                "type" => "hard",
                "data" => [],
            ],
        ]);

        $this->assertJsonStringEqualsJsonString($jsonStringExpected, $serializeObject);
    }

    /**
     * @test
     * @throws \Exception
     */
    public function correctValidOptions()
    {
        $options = [
            'type' => 'counter',
            'data' => [
                'counterLimit' => 3
            ]
        ];

        $object = $this->payWallObject($options);

        $this->assertEquals(
            $object->getPayWallOptions(),
            $options
        );

        $options = [
            'type' => 'hard',
            'data' => []
        ];

        $object = $this->payWallObject($options);

        $this->assertEquals(
            $object->getPayWallOptions(),
            $options
        );
    }

    /**
     * @test
     * @throws \Exception
     */
    public function validOptionsType()
    {
        $this->expectExceptionMessage('Invalid type bar. Type must be one of: date,counter,hard');

        $this->payWallObject([
            'type' => 'bar',
            'data' => []
        ]);
    }

    /**
     * @test
     * @throws \Exception
     */
    public function validOptions()
    {
        $this->expectExceptionMessage('Type and data must be provided for paywall options');

        $this->payWallObject([
            'foo' => 'bar'
        ]);
    }

    /**
     * @test
     * @throws \Exception
     */
    public function counterOptions()
    {
        $this->expectExceptionMessage('counterLimit option must be provided for counter type. Options provided under data are: foo');

        $this->payWallObject([
            'type' => 'counter',
            'data' => [
                "foo" => 'bar'
            ],
        ]);
    }

    /**
     * @test
     * @throws \Exception
     */
    public function dataOptionsMustBeArray()
    {
        $this->expectExceptionMessage('Data option type must be an array');

        $this->payWallObject([
            'type' => 'counter',
            'data' => 'foo',
        ]);
    }
}