<?php

namespace Comitium5\CommonWidgetsBundle\PayWall\Token;

use Comitium5\CommonWidgetsBundle\PayWall\ValueObject\PayWallObject;
use Comitium5\CommonWidgetsBundle\Services\Security\DataEncryption;

/**
 * Class PayWallToken
 *
 * @author Óscar Jimenez <oscar@bab-soft.com>
 * @package Paywall\Token
 */
class PayWallToken
{
    /**
     * @param PayWallObject $payWallTokenObject
     *
     * @return string
     * @throws \ReflectionException
     * @throws \Exception
     */
    public function encrypt(PayWallObject $payWallTokenObject)
    {
        $dataEncryption = $this->dataEncryptionObject($payWallTokenObject->serialize());

        return $dataEncryption->encrypt();
    }

    /**
     * @param $tokenString
     *
     * @return PayWallObject
     * @throws \Exception
     */
    public function decrypt($tokenString)
    {
        $dataEncryption = $this->dataEncryptionObject($tokenString);

        $payWallData = $dataEncryption->decrypt();

        if (!empty($payWallData)) {
            $payWallData = json_decode($payWallData, true);

            return new PayWallObject(
                $payWallData['objectId'],
                $payWallData['objectType'],
                $payWallData['objectSubscriptions'],
                $payWallData['privateContentTemplate'],
                $payWallData['privateContentData'],
                $payWallData['payWallTemplate'],
                $payWallData['payWallTemplateData'],
                $payWallData['cacheTTL'],
                $payWallData['cacheTTLSecondsToIncrease'],
                $payWallData['payWallOptions'],
                $payWallData['cacheKeyPrefix']
            );

        }

        throw new \Exception('Invalid token for paywall decryption');
    }

    /**
     * @param $data
     *
     * @return DataEncryption
     * @throws \Exception
     */
    private function dataEncryptionObject($data)
    {
        return new DataEncryption($data);
    }
}