<?php

namespace Comitium5\CommonWidgetsBundle\Tests\Services\Security;

use Comitium5\CommonWidgetsBundle\Services\Security\TokenEncryption;
use Comitium5\CommonWidgetsBundle\Tests\TestCase;

/**
 * Class TokenEncryptionTest
 * @package Comitium5\CommonWidgetsBundle\Tests\Services\Security
 */
class TokenEncryptionTest extends TestCase
{
    /**
     * @test
     * @throws \Exception
     * phpunit Tests/Services/Security/TokenEncryptionTest.php
     */
    public function encryption()
    {
        $data = "this is a test";

        $service       = new TokenEncryption($data);
        $encryptedData = $service->encrypt();

        $service       = new TokenEncryption($encryptedData);
        $decryptedData = $service->decrypt();

        $this->assertEquals($data, $decryptedData);

    }

    /**
     * @test
     * @throws \Exception
     * phpunit Tests/Services/Security/TokenEncryptionTest.php
     */
    public function encryptionErrorNonString()
    {
        $this->expectException(\Exception::class);

        new TokenEncryption(["foo" => "bar"]);

    }

    /**
     * @test
     * @throws \Exception
     * phpunit Tests/Services/Security/TokenEncryptionTest.php
     */
    public function encryptionErrorEmptyString()
    {
        $this->expectException(\Exception::class);

        new TokenEncryption("  ");
    }
}
