<?php

namespace Comitium5\CommonWidgetsBundle\Services;

use Comitium5\CommonWidgetsBundle\Cache\MemoryCacheInterface;

/**
 * Class ParametersStorage
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Services
 */
class ParametersStorage
{
    const UUID = "_uuid";

    const KEY  = "storage_parameters_%s";

    /**
     * @var MemoryCacheInterface
     */
    private $cache;

    /**
     * ParametersStorage constructor.
     * @param MemoryCacheInterface $cache
     */
    public function __construct(MemoryCacheInterface $cache)
    {
        $this->cache = $cache;
    }

    /**
     * @param array $parameters
     * @param null $key
     * @param null $ttl
     * @throws \Exception
     */
    public function stash(array $parameters, $key = null, $ttl = null)
    {
        if ($key === null) {
            if (!isset($parameters[self::UUID])) {
                throw new \Exception("Uuid parameters must be provided");
            }

            $key = $parameters[self::UUID];
        }

        $this->cache->set($this->buildKey($key), $parameters, $ttl);
    }

    /**
     * @param $key
     */
    public function pop($key)
    {
        return $this->cache->get($this->buildKey($key));
    }

    /**
     * @param $key
     */
    public function delete($key)
    {
        $this->cache->delete($this->buildKey($key));
    }

    /**
     * @param $key
     * @return string
     */
    public function buildKey($key)
    {
        return sprintf(self::KEY, $key);
    }
}