<?php

namespace Comitium5\CommonWidgetsBundle\Tests\Services\Poll;

use Comitium5\ApiClientBundle\Client\Client;
use Comitium5\CommonWidgetsBundle\Services\Poll\PollService;
use Comitium5\CommonWidgetsBundle\Tests\TestCase;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Class PollServiceTest
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Tests\Services\Poll
 */
class PollServiceTest extends TestCase
{
    /**
     *
     */
    public function testFetchPoll()
    {
        $service = new PollService($this->apiClient(), 1);

        $poll = $service->fetchPoll();

        $this->assertEquals('Poll title', $poll['title']);
    }

    /**
     *
     */
    public function testResolvePoll()
    {
        $service = new PollService($this->apiClient(), 1);

        $response = $service->resolvePoll();

        $this->assertInstanceOf(JsonResponse::class, $response);
        $this->assertStringContainsString('Pregunta 1', $response->getContent());
        $this->assertStringContainsString('Pregunta 2', $response->getContent());
    }

    /**
     * @return \PHPUnit_Framework_MockObject_MockObject|Client
     */
    private function apiClient()
    {
        $api = $this->createMock(Client::class);

        $api->method('find')->willReturn([
            'statusCode' => 200,
            'data' => [
                'id' => 1,
                'title' => 'Poll title',
                'answers' => [
                    [
                        'id' => 1,
                        'votes' => 5,
                        'answer' => 'Pregunta 1'
                    ],
                    [
                        'id' => 2,
                        'votes' => 0,
                        'answer' => 'Pregunta 2'
                    ],
                ],
            ]
        ]);

        return $api;
    }
}
