<?php

namespace Comitium5\CommonWidgetsBundle\Services\Interfaces;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Result;
use Doctrine\DBAL\Statement;

/**
 * Interface DataBaseConnectionInterface
 * @package Comitium5\CommonWidgetsBundle\Services\Interfaces
 */
interface DataBaseConnectionInterface
{
    /**
     * @param Statement $statement
     * @return mixed
     */
    public function setStatement(Statement $statement);

    /**
     * @return mixed
     */
    public function getStatement(): ?Statement;

    /**
     * @param Connection $connection
     * @return mixed
     */
    public function setConnection(Connection $connection);

    /**
     * @return mixed
     */
    public function getConnection(): ?Connection;

    /**
     * @param $stringConnection
     * @return mixed
     */
    public function connect($stringConnection);

    /**
     * @return mixed
     */
    public function disconnect();

    /**
     * @param $query
     * @return mixed
     */
    public function execute($query): Result;
}