<?php

namespace Comitium5\CommonWidgetsBundle\Services;

use Comitium5\CommonWidgetsBundle\Services\Interfaces\DataBaseConnectionInterface;
use Doctrine\DBAL\DriverManager;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception;
use Doctrine\DBAL\Result;
use Doctrine\DBAL\Statement;

/**
 * Class ExternalDataBaseConnection
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Services
 */
class ExternalDataBaseConnection implements DataBaseConnectionInterface
{
    /**
     * @var Connection
     */
    protected $connection;

    /**
     * @var Statement
     */
    protected $statement;

    /**
     * @param $stringConnection
     * @return $this
     * @throws Exception
     */
    public function connect($stringConnection)
    {
        $this->connection = DriverManager::getConnection([
            "url" => $stringConnection
        ]);

        return $this;
    }

    public function disconnect()
    {
        $this->connection?->close();
    }

    /**
     * @param $query
     * @throws Exception
     */
    public function execute($query): Result
    {
        $this->statement = $this->connection->prepare($query);

        return $this->statement->executeQuery();
    }

    /**
     * @return $this
     */
    public function setStatement(Statement $statement)
    {
        $this->statement = $statement;

        return $this;
    }

    public function getStatement(): Statement
    {
        return $this->statement;
    }

    /**
     * @return $this
     */
    public function setConnection(Connection $connection)
    {
        $this->connection = $connection;

        return $this;
    }

    public function getConnection(): Connection
    {
        return $this->connection;
    }
}