<?php

namespace Comitium5\ApiClientBundle\Tests\Normalizers;

use Comitium5\ApiClientBundle\Normalizer\ApiNormalizator;
use Comitium5\ApiClientBundle\Tests\Stubs\CategoryNormalizerStub;
use Comitium5\ApiClientBundle\Tests\Stubs\FooNormalizerStub;
use Comitium5\ApiClientBundle\Tests\TestCase;


/**
 * Class NormalizatorTest
 * @package Tests\Normalizers
 */
class NormalizatorTest extends TestCase
{
    /**
     * @test
     */
    public function withoutNormalizers()
    {
        $entity = [
            "id" => 1,
            "categories" => [
                "id" => 1,
            ]
        ];

        $normalizator = new ApiNormalizator([]);
        $normalized = $normalizator->normalize($entity);

        $this->assertEquals($normalized, $entity);

    }

    /**
     * @test
     */
    public function withNormalizers()
    {
        $entity = [
            "id" => 1,
            "categories" => [
                ["id" => 1],
                ["id" => 2],
            ]
        ];

        $expectedEntity =[
            "id" => 1,
            "foo" => "bar",
            "categories" => [
                [
                    "id"    => 1,
                    "title" => "foo"
                ],
                [
                    "id"    => 2,
                ]
            ]
        ];

        $normalizator = new ApiNormalizator($this->getNormalizers());
        $normalized   = $normalizator->normalize($entity);

        /**
         * assertArraySubset once deprecated: https://packagist.org/packages/dms/phpunit-arraysubset-asserts
         */
        $this->assertArraySubset($expectedEntity, $normalized);
        $this->assertEquals($entity, $entity);

        $normalizator = new ApiNormalizator($this->getNormalizersInverse());
        $normalized   = $normalizator->normalize($entity);

        $this->assertArraySubset($expectedEntity, $normalized);
        $this->assertEquals($entity, $entity);

    }

    /**
     * @return array
     */
    private function getNormalizers()
    {
        return [
            new CategoryNormalizerStub(),
            new FooNormalizerStub(),
        ];
    }

    /**
     * @return array
     */
    private function getNormalizersInverse()
    {
        return [
            new FooNormalizerStub(),
            new CategoryNormalizerStub(),
        ];
    }
}
