<?php

namespace Comitium5\ApiClientBundle\Tests\Normalizers;

use Comitium5\ApiClientBundle\Client\Services\AssetApiService;
use Comitium5\ApiClientBundle\Normalizer\ApiNormalizator;
use Comitium5\ApiClientBundle\Normalizer\AssetsApiNormalizer;
use Comitium5\ApiClientBundle\Tests\Stubs\ApiClientStub;
use Comitium5\ApiClientBundle\Tests\TestCase;

/**
 * Class AssetApiNormalizerTest
 * @package Comitium5\ApiClientBundle\Tests\Normalizers
 */
class AssetApiNormalizerTest extends TestCase
{
    /**
     * @test
     */
    public function normalizerFirst()
    {
        $entity = [
            "id"     => 1,
            "assets" => [
                ["id" => 1],
                ["id" => 2],
            ],
        ];

        $expectedEntity = [
            "id"     => 1,
            "assets" => [
                [
                    "id"  => 1,
                    "src" => "/foo/bar.png",
                ],
            ],
        ];

        $normalizator = new ApiNormalizator([new AssetsApiNormalizer($this->service(), 1)]);
        $normalized = $normalizator->normalize($entity);

        $this->assertEquals($expectedEntity, $normalized);
    }

    /**
     * @test
     */
    public function normalizerAll()
    {
        $entity = [
            "id"     => 1,
            "assets" => [
                ["id" => 1],
                ["id" => 2],
            ],
        ];

        $expectedEntity = [
            "id"     => 1,
            "assets" => [
                [
                    "id"  => 1,
                    "src" => "/foo/bar.png",
                ],
                [
                    "id"  => 2,
                    "src" => "/foo/bar.png",
                ],
            ],
        ];

        $normalizator = new ApiNormalizator([new AssetsApiNormalizer($this->service())]);
        $normalized = $normalizator->normalize($entity);

        $this->assertEquals($expectedEntity, $normalized);
    }

    /**
     * @test
     */
    public function normalizerWithEmptyAsset()
    {
        $entity = [
            "id"     => 1,
            "assets" => [
                ["id" => 1],
                ["id" => 999],
                ["id" => 2],
                ["id" => 3],
            ],
        ];

        $expectedEntity = [
            "id"     => 1,
            "assets" => [
                [
                    "id"  => 1,
                    "src" => "/foo/bar.png",
                ],
                [
                    "id"  => 2,
                    "src" => "/foo/bar.png",
                ],
                [
                    "id"  => 3,
                    "src" => "/foo/bar.png",
                ],
            ],
        ];

        $normalizator = new ApiNormalizator([new AssetsApiNormalizer($this->service())]);
        $normalized = $normalizator->normalize($entity);

        $this->assertEquals($expectedEntity, $normalized);
    }

    /**
     * @test
     */
    public function normalizerTwoOrMore()
    {
        $entity = [
            "id"     => 1,
            "assets" => [
                ["id" => 1],
                ["id" => 2],
                ["id" => 3],
                ["id" => 4],
                ["id" => 5],
            ],
        ];

        $expectedEntity = [
            "id"     => 1,
            "assets" => [
                [
                    "id"  => 1,
                    "src" => "/foo/bar.png",
                ],
                [
                    "id"  => 2,
                    "src" => "/foo/bar.png",
                ],
            ],
        ];

        $normalizator = new ApiNormalizator([new AssetsApiNormalizer($this->service(), 2)]);
        $normalized = $normalizator->normalize($entity);

        $this->assertEquals($expectedEntity, $normalized);

        $entity = [
            "id"     => 1,
            "assets" => [
                ["id" => 1],
                ["id" => 2],
                ["id" => 3],
            ],
        ];

        $expectedEntity = [
            "id"     => 1,
            "assets" => [
                [
                    "id"  => 1,
                    "src" => "/foo/bar.png",
                ],
                [
                    "id"  => 2,
                    "src" => "/foo/bar.png",
                ],
                [
                    "id"  => 3,
                    "src" => "/foo/bar.png",
                ],
            ],
        ];

        $normalizator = new ApiNormalizator([new AssetsApiNormalizer($this->service(), 4)]);
        $normalized = $normalizator->normalize($entity);

        $this->assertEquals($expectedEntity, $normalized);
    }

    /**
     * @test
     */
    public function normalizerError()
    {
        $entity = [
            "id"     => 1,
            "assets" => [
                ["id" => 1],
                ["id" => 2],
            ],
        ];

        $expectedEntity = [
            "id"     => 1,
            "assets" => [
                [
                    "id"  => 1,
                    "src" => "/foo/bar.png",
                ],
                [
                    "id"  => 2,
                    "src" => "/foo/bar.png",
                ],
            ],
        ];

        $normalizator = new ApiNormalizator([new AssetsApiNormalizer($this->service(), 1)]);
        $normalized = $normalizator->normalize($entity);

        $this->assertNotEquals($expectedEntity, $normalized);
    }

    /**
     * @return AssetApiService
     */
    private function service()
    {
        return new AssetApiService(new ApiClientStub("http://foo.com", "xxxx"));
    }
}