<?php

namespace Comitium5\ApiClientBundle\Client\Services;

use Comitium5\ApiClientBundle\ApiClient\ResourcesTypes;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class PagesApiService
 * @package Comitium5\ApiClientBundle\Client\Services
 */
class PagesApiService extends AbstractApiService
{
    /**
     * @param IdentifiedValue $identifiedValue
     * @return array|mixed
     * @throws \Exception
     */
    public function find(IdentifiedValue $identifiedValue)
    {
        $response = $this->fetch(
            $identifiedValue,
            ResourcesTypes::PAGE
        );

        return $this->handleResponse($response);
    }

    /**
     * @param ParametersValue $parametersValue
     * @return array
     * @throws \Exception
     */
    public function findBy(ParametersValue $parametersValue)
    {
        $response = $this->fetchBy(
            $parametersValue,
            ResourcesTypes::PAGE
        );

        return $this->handleResponse($response);
    }

    /**
     * @throws \Exception
     */
    public function publish(IdentifiedValue $id): void
    {
        $this->update(
            $id,
            new ParametersValue([]),
            (ResourcesTypes::PAGE."/publish")
        );
    }

    /**
     * @throws \Exception
     */
    public function getContent(IdentifiedValue $id): array
    {
        $response = $this->fetch(
            $id,
            ResourcesTypes::PAGE."/content"
        );

        return $this->handleResponse($response);
    }

    /**
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function getDraftContent(IdentifiedValue $id, ?string $draftId = null): array
    {
        $url = ResourcesTypes::PAGE."/content/".$id->getId()."/draft";

        if ($draftId) {
            $url .= "/".$draftId;
        }

        $response = $this
            ->apiClient
            ->get($url);

        return $this->handleResponse($response);
    }
}