<?php

namespace Comitium5\ApiClientBundle\Client\Services;

use Comitium5\ApiClientBundle\ApiClient\ResourcesTypes;
use Comitium5\ApiClientBundle\Utils\ResponseUtils;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class CommentApiService
 * @package Comitium5\ApiClientBundle\Client\Services
 */
class CommentApiService extends AbstractApiService implements ApiServiceMutationInterface
{
    /**
     * @param IdentifiedValue $identifiedValue
     * @return array|mixed
     * @throws \Exception
     */
    public function find(IdentifiedValue $identifiedValue)
    {
        $response = $this->fetch(
            $identifiedValue,
            ResourcesTypes::COMMENT
        );

        return $this->handleResponse($response);
    }

    /**
     * @param ParametersValue $parametersValue
     * @return array
     * @throws \Exception
     */
    public function findBy(ParametersValue $parametersValue)
    {
        $response = $this->fetchBy(
            $parametersValue,
            ResourcesTypes::COMMENT
        );

        return $this->handleResponse($response);
    }

    /**
     * @param ParametersValue $parametersValue
     * @return array|false|mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function count(ParametersValue $parametersValue)
    {
        $parameters = $parametersValue->getOptions();

        if (empty($parameters['contentType']) || empty($parameters['contentId'])) {
            return false;
        }

        $response =  $this
            ->apiClient
            ->get(
                ResourcesTypes::COMMENT.'/count/'.$parameters['contentType'].'/'.$parameters['contentId']
        );

        return $this->handleCountResponse($response);
    }

    /**
     * @param ParametersValue $parametersValue
     * @return array
     * @throws \Exception
     */
    public function post(ParametersValue $parametersValue)
    {
        $response = $this->create(
            $parametersValue,
            ResourcesTypes::COMMENT
        );

        return $this->handleResponse($response);
    }

    /**
     * @param IdentifiedValue $identifiedValue
     * @param ParametersValue $parametersValue
     * @return array
     * @throws \Exception
     */
    public function put(IdentifiedValue $identifiedValue, ParametersValue $parametersValue)
    {
        $response = $this->update(
            $identifiedValue,
            $parametersValue,
            ResourcesTypes::COMMENT
        );

        return $this->handleResponse($response);
    }

    /**
     * @param array $response
     * @return array|mixed
     */
    protected function handleCountResponse(array $response)
    {
        return ResponseUtils::isValidResponse($response) ? $response['data']["count"] : false;
    }
}