<?php

namespace Comitium5\ApiClientBundle\ValueObject;

/**
 * Class FileFieldValue
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package ValueObject
 */
class FileValue
{

    /**
     * @var string
     */
    protected $fieldName;

    /**
     * @var array
     */
    protected $paths;

    /**
     * FileValue constructor.
     *
     * @param $fieldName
     * @param $paths
     */
    public function __construct($fieldName, $paths)
    {
        $this->fieldName = is_array($paths) ? ($fieldName."[]") : $fieldName;
        $this->paths = is_array($paths) ? $paths : [$paths];
    }

    /**
     * @return string
     */
    public function getFieldName()
    {
        return $this->fieldName;
    }

    /**
     * @return array
     */
    public function getPaths()
    {
        return $this->paths;
    }

    /**
     * @param $path
     *
     * @return array
     */
    public function addPath($path)
    {
        $this->paths[] = $path;

        return $this->getPaths();
    }

}