<?php

namespace Comitium5\ApiClientBundle\Tests\Utils;

use Comitium5\ApiClientBundle\Tests\TestCase;
use Comitium5\ApiClientBundle\Utils\FieldsUtils;

/**
 * Class FieldsUtilsTest
 *
 * @package Comitium5\ApiClientBundle\Tests\Utils
 */
class FieldsUtilsTest extends TestCase
{
    public function testShouldGetFieldValue(): void
    {
        $values = [
            "body_cuerpo" => ['values' => ["Cos de la noticia"]],
            "short_text_subtitle" => ['values' => ["Subtítol de la noticia"]],
            "short_text_freeauthor" => ['values' => ["Autor lliure de la noticia"]],
        ];

        $actual = FieldsUtils::fieldValue("body_cuerpo", $values);

        $this->assertEquals("Cos de la noticia", $actual);
    }

    public function testShouldGetDefaultValue(): void
    {
        $values = [
            "body_cuerpo" => ['values' => ["Cos de la noticia"]],
            "short_text_subtitle" => ['values' => ["Subtítol de la noticia"]],
            "short_text_freeauthor" => ['values' => ["Autor lliure de la noticia"]],
        ];

        $actual = FieldsUtils::fieldValue("body_body", $values, "Default value");

        $this->assertEquals("Default value", $actual);
    }

    public function testShouldGetEmptyDefaultValue(): void
    {
        $values = [
            "body_cuerpo" => ['values' => ["Cos de la noticia"]],
            "short_text_subtitle" => ['values' => ["Subtítol de la noticia"]],
            "short_text_freeauthor" => ['values' => ["Autor lliure de la noticia"]],
        ];

        $actual = FieldsUtils::fieldValue("body_body", $values);

        $this->assertEquals("", $actual);
    }

    public function testShouldGetLoopField(): void
    {
        $values = [
            "loop_documents" => [
                [
                    "document_document" => [
                        "values" => [1],
                    ],
                ],
            ],
            "short_text_subtitle" => ['values' => ["Subtítol de la noticia"]],
            "short_text_freeauthor" => ['values' => ["Autor lliure de la noticia"]],
        ];

        $actual = FieldsUtils::loopField("loop_documents", $values);

        $this->assertEquals([["document_document" => ["values" => [1]]]], $actual);
    }

    public function testShouldGetEmptyLoopFieldIfNotExist(): void
    {
        $values = [
            "loop_documents" => [
                [
                    "document_document" => [
                        "values" => [1],
                    ],
                ],
            ],
            "short_text_subtitle" => ['values' => ["Subtítol de la noticia"]],
            "short_text_freeauthor" => ['values' => ["Autor lliure de la noticia"]],
        ];

        $actual = FieldsUtils::loopField("loop_no_exists", $values);

        $this->assertEquals([], $actual);
    }
}