<?php

namespace Comitium5\ApiClientBundle\Utils;

/**
 * Class ResponseUtils
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Utils
 */
class ResponseUtils
{
    public static function isValidResponse(array $response): bool
    {
        return $response["statusCode"] >= 200 && $response["statusCode"] < 300;
    }

    /**
     * @param array $response
     *
     * @return array
     */
    public static function handleResponse(array $response): array
    {
        return self::isValidResponse($response) ? $response["data"] : [];
    }
}
