<?php

namespace Comitium5\ApiClientBundle\Client\Services;

use Comitium5\ApiClientBundle\ApiClient\ResourcesTypes;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;

/**
 * Class SubscriptionApiService
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Client\Services
 */
class SubscriptionApiService extends AbstractApiService
{
    /**
     * @param IdentifiedValue $identifiedValue
     *
     * @return array
     * @throws \Exception
     */
    public function find(IdentifiedValue $identifiedValue)
    {
        $response = $this->fetch(
            $identifiedValue,
            ResourcesTypes::SUBSCRIPTION
        );

        return $this->handleResponse($response);
    }

    /**
     * @param ParametersValue $parametersValue
     *
     * @return array
     * @throws \Exception
     */
    public function findBy(ParametersValue $parametersValue)
    {
        $response = $this->fetchBy(
            $parametersValue,
            ResourcesTypes::SUBSCRIPTION
        );

        return $this->handleResponse($response);
    }
}
