<?php

namespace Comitium5\ApiClientBundle\Client\Services;

use Comitium5\ApiClientBundle\ApiClient\ResourcesTypes;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;
use Comitium5\ApiClientBundle\ValueObject\Product\ProductObject;

/**
 * Class OrderApiService
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Client\Services
 */
class OrderApiService extends AbstractApiService
{
    /**
     * @param IdentifiedValue $identifiedValue
     *
     * @return array
     * @throws \Exception
     */
    public function find(IdentifiedValue $identifiedValue)
    {
        $response = $this->fetch(
            $identifiedValue,
            ResourcesTypes::ORDER
        );

        return $this->handleResponse($response);
    }

    /**
     * @param ParametersValue $parametersValue
     *
     * @return array
     * @throws \Exception
     */
    public function findBy(ParametersValue $parametersValue)
    {
        $response = $this->fetchBy(
            $parametersValue,
            ResourcesTypes::ORDER
        );

        return $this->handleResponse($response);
    }

    /**
     * @param ParametersValue $parametersValue
     * @param ProductObject $productValueObject
     *
     * @return array
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function post(ParametersValue $parametersValue, ProductObject $productValueObject)
    {
        $response = $this
            ->apiClient
            ->post(
                ResourcesTypes::ORDER.DIRECTORY_SEPARATOR.$this->resolveProductType($productValueObject),
                $parametersValue->getOptions()
            );

        return $this->handleResponse($response);
    }

    /**
     * @param IdentifiedValue $identifiedValue
     * @param ParametersValue $parametersValue
     * @param ProductObject $productValueObject
     *
     * @return array
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function put(
        IdentifiedValue $identifiedValue,
        ParametersValue $parametersValue,
        ProductObject $productValueObject
    ) {
        $response = $this
            ->apiClient
            ->put(
                ResourcesTypes::ORDER
                .DIRECTORY_SEPARATOR
                .$identifiedValue->getId()
                .DIRECTORY_SEPARATOR
                .$this->resolveProductType($productValueObject),
                $parametersValue->getOptions()
            );

        return $this->handleResponse($response);
    }

    /**
     * @param ProductObject $productValueObject
     *
     * @return string
     */
    protected function resolveProductType(ProductObject $productValueObject)
    {
        return $productValueObject->getResourceType()
            .DIRECTORY_SEPARATOR
            .$productValueObject
                ->getIdentifiedValue()
                ->getId();
    }
}
