<?php

namespace Comitium5\ApiClientBundle\Client;

use Comitium5\ApiClientBundle\Utils\ResponseUtils;
use GuzzleHttp\Client as GuzzleClient;
use Comitium5\ApiClientBundle\Normalizer\RequestParametersNormalizer\RequestParametersNormalizerInterface;

/**
 * Class Client
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\ApiClientBundle\Client
 */
class Client extends RestClient implements ClientInterface
{
    /**
     * @param $site
     * @param $subSite
     * @param $locale
     * @param null $token
     * @param bool $verify
     * @param bool $httpErrors
     *
     * @return $this
     */
    public function buildClient(
        $site,
        $subSite,
        $locale,
        $token = null,
        $verify = false,
        $httpErrors = true
    ) {
        $headers = [
            self::HEADER_AUTH     => sprintf("Bearer %s", $token !== null ? $token : $this->token),
            self::HEADER_SITE     => $site,
            self::HEADER_SUB_SITE => $subSite,
            self::HEADER_LANGUAGE => $locale,
        ];

        $this->client = new GuzzleClient([
            'verify'      => $verify,
            'http_errors' => $httpErrors,
            'base_uri'    => $this->endPoint,
            'headers'     => $headers,
        ]);

        return $this;
    }


    /**
     * @param $resourceType
     * @param $id
     * @return array|mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function find($resourceType, $id)
    {
        return $this->get(UrlResolver::resolveUrlPathByResourceType($resourceType, $id));
    }

    /**
     * @param $resourceType
     * @param array|RequestParametersNormalizerInterface $parameters
     * @return array|mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function findBy($resourceType, $parameters)
    {
        $response = $this->get(
            UrlResolver::resolveUrlPathByResourceType($resourceType),
            $parameters
        );

        if (ResponseUtils::isValidResponse($response)) {
            foreach ($response['data']['results'] as $key => &$result) {
                $entityResponse = $this->find($resourceType, $result['id']);

                if (ResponseUtils::isValidResponse($entityResponse)) {
                    $result = $entityResponse['data'];
                } else {
                    unset($response['data']['results'][$key]);
                }
            }
        }

        return $response;
    }

    /**
     * @param $resourceType
     * @param array|RequestParametersNormalizerInterface $parameters
     * @return array|mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function create($resourceType, $parameters)
    {
        return $this->post(
            UrlResolver::resolveUrlPathByResourceType($resourceType),
            $parameters
        );
    }

    /**
     * @param $resourceType
     * @param $id
     * @param array|RequestParametersNormalizerInterface $parameters
     * @return array|mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function update($resourceType, $id, $parameters)
    {
        return $this->put(
            UrlResolver::resolveUrlPathByResourceType($resourceType, $id),
            $parameters
        );
    }

    /**
     * @param $resourceType
     * @param $id
     * @return array|mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function remove($resourceType, $id)
    {
        return $this->delete(
            UrlResolver::resolveUrlPathByResourceType($resourceType, $id)
        );
    }
}
