<?php

namespace Client\Services;

use Comitium5\ApiClientBundle\Client\Services\ArticleApiService;
use Comitium5\ApiClientBundle\Tests\Stubs\ApiClientStub;
use Comitium5\ApiClientBundle\Tests\TestCase;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;
use Exception;

/**
 * Class MenuApiServiceTest
 *
 * @package Client\Services
 */
class MenuApiServiceTest extends TestCase
{
    /**
     * @test
     * @throws Exception
     */
    public function find()
    {
        $service = new ArticleApiService(new ApiClientStub("http://api.mock.com", "ABDCFGHY"));
        $menu = $service->find(new IdentifiedValue(2));

        $this->assertEquals($menu["id"], 2);
    }

    /**
     * @test
     * @throws Exception
     */
    public function findBy()
    {
        $service = new ArticleApiService(new ApiClientStub("http://api.mock.com", "ABDCFGHY"));
        $menus = $service->findBy(new ParametersValue(["limit" => 3]));

        $this->assertEquals(count($menus["results"]), 3);
    }
}