<?php

namespace Comitium5\ApiClientBundle\Normalizer;

use Comitium5\ApiClientBundle\Client\Services\CategoryApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class CategoriesApiNormalizer
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\ApiClientBundle\Normalizer
 */
class CategoriesApiNormalizer implements NormalizerInterface
{
    /**
     * @var CategoryApiService
     */
    private $entityService;

    /**
     * @var int|null
     */
    private $numberOfElements;

    /**
     * CategoriesApiNormalizer constructor.
     * @param CategoryApiService $entityService
     * @param int $numberOfElements
     */
    public function __construct (CategoryApiService $entityService, $numberOfElements = 1)
    {
        $this->entityService    = $entityService;
        $this->numberOfElements = $numberOfElements;
    }

    /**
     * @param array $entity
     *
     * @return array|mixed
     * @throws \Exception
     */
    public function normalize (array &$entity)
    {
        $normalizedCategories = [];

        $i = 0;

        foreach ($entity['categories'] as $category) {
            $category = $this->entity(new IdentifiedValue($category['id']));

            if (empty($category)) {
                continue;
            }

            $normalizedCategories[] = $category;

            $i++;

            if ($this->numberOfElements !== null && $i >= $this->numberOfElements) {
                break;
            }
        }

        $entity['categories'] = $normalizedCategories;

        return $entity;
    }

    /**
     * @param IdentifiedValue $identifiedValue
     * @return array|mixed
     * @throws \Exception
     */
    protected function entity (IdentifiedValue $identifiedValue)
    {
        return $this
            ->entityService
            ->find($identifiedValue);
    }
}