<?php

namespace Comitium5\ApiClientBundle\Client\Services;

use Comitium5\ApiClientBundle\Client\Client;
use Comitium5\ApiClientBundle\Normalizer\RequestParametersNormalizer\RequestParametersNormalizerInterface;
use Comitium5\ApiClientBundle\Utils\ResponseUtils;

/**
 * Class MailingApiService
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\ApiClientBundle\Client\Services
 */
class MailingApiService
{
    const MAILING_API_ENDPOINT = "mailing/send";

    /**
     * @var Client
     */
    protected $apiClient;

    /**
     * AbstractApiService constructor.
     *
     * @param $apiClient
     */
    public function __construct(Client $apiClient)
    {
        $this->apiClient = $apiClient;
    }

    /**
     * @param array $response
     *
     * @return array|mixed
     */
    protected function handleResponse(array $response)
    {
        return ResponseUtils::isValidResponse($response) ? $response["statusCode"] : [];
    }

    /**
     * @param RequestParametersNormalizerInterface $parameters
     *
     * @return array|mixed
     */
    public function send(RequestParametersNormalizerInterface $parameters)
    {
        $response = $this->apiClient->post(
            self::MAILING_API_ENDPOINT,
            $parameters
        );

        return $this->handleResponse($response);
    }
}