<?php

namespace Comitium5\ApiClientBundle\Client\Services;

use Comitium5\ApiClientBundle\ApiClient\ResourcesTypes;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class ContestApiService
 * @package Comitium5\ApiClientBundle\Client\Services
 */
class ContestApiService extends AbstractApiService
{
    /**
     * @param IdentifiedValue $identifiedValue
     * @return array|mixed
     * @throws \Exception
     */
    public function find(IdentifiedValue $identifiedValue)
    {
        $response = $this->fetch(
            $identifiedValue,
            ResourcesTypes::CONTEST
        );

        return $this->handleResponse($response);
    }

    /**
     * @param ParametersValue $parametersValue
     * @return array
     * @throws \Exception
     */
    public function findBy(ParametersValue $parametersValue)
    {
        $response = $this->fetchBy(
            $parametersValue,
            ResourcesTypes::CONTEST
        );

        return $this->handleResponse($response);
    }

    /**
     * @param ParametersValue $parametersValue
     * @return array
     * @throws \Exception
     */
    public function post(ParametersValue $parametersValue)
    {
        $response = $this->create(
            $parametersValue,
            ResourcesTypes::CONTEST
        );

        return $this->handleResponse($response);
    }
}