<?php

namespace Tests\Normalizers;

use Comitium5\ApiClientBundle\Client\Services\CategoryApiService;
use Comitium5\ApiClientBundle\Normalizer\CategoriesApiNormalizer;
use Comitium5\ApiClientBundle\Tests\Stubs\ApiClientStub;
use Comitium5\ApiClientBundle\Tests\TestCase;

/**
 * Class TagsApiNormalizerTest
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Tests\Normalizers
 */
class CategoriesApiNormalizerTest extends TestCase
{
    /**
     * @param $entity
     * @param $expected
     * @param $numberOfElements
     *
     * @test
     * @dataProvider getData
     *
     * @throws \Exception
     */
    public function normalize($entity, $expected, $numberOfElements = 1)
    {
        $categoryApiService = $this->getCategoryApiService();

        $categoriesApiNormalizer = new CategoriesApiNormalizer($categoryApiService, $numberOfElements);

        $categoriesApiNormalizer->normalize($entity);

        $this->assertEquals($expected, $entity);
    }

    /**
     * @return array
     */
    public function getData()
    {
        return [
            // Behaviour: most used (without number of elements)
            [
                'entity'           => [
                    'id'   => 1,
                    'categories' => [
                        [
                            'id' => 1,
                        ],
                        [
                            'id' => 2,
                        ],
                    ],
                ],
                'expected'         => [
                    'id'   => 1,
                    'categories' => [
                        [
                            'id' => 1,
                            'title' => "Category title"
                        ],
                    ],
                ],
            ],
            // Behaviour: null number of elements
            [
                'entity'           => [
                    'id'   => 1,
                    'categories' => [
                        [
                            'id' => 1,
                        ],
                        [
                            'id' => 2,
                        ],
                    ],
                ],
                'expected'         => [
                    'id'   => 1,
                    'categories' => [
                        [
                            'id' => 1,
                            'title' => "Category title"
                        ],
                        [
                            'id' => 2,
                            'title' => "Category title"
                        ],
                    ],
                ],
                'numberOfElements' => null,
            ],
            // Behaviour: with number of elements passed by argument
            [
                'entity'           => [
                    'id'   => 1,
                    'categories' => [
                        [
                            'id' => 1,
                        ],
                        [
                            'id' => 2,
                        ],
                    ],
                ],
                'expected'         => [
                    'id'   => 1,
                    'categories' => [
                        [
                            'id' => 1,
                            'title' => "Category title"
                        ],
                    ],
                ],
                'numberOfElements' => 1,
            ],
            // Behaviour: with an empty result for id 999
            [
                'entity'           => [
                    'id'   => 1,
                    'categories' => [
                        [
                            'id' => 1,
                        ],
                        [
                            'id' => 999,
                        ],
                        [
                            'id' => 2,
                        ],
                    ],
                ],
                'expected'         => [
                    'id'   => 1,
                    'categories' => [
                        [
                            'id' => 1,
                            'title' => "Category title"
                        ],
                        [
                            'id' => 2,
                            'title' => "Category title"
                        ],
                    ],
                ],
                'numberOfElements' => null,
            ],
            // Behaviour: with an empty result for id 999 and number of elements set
            [
                'entity'           => [
                    'id'   => 1,
                    'categories' => [
                        [
                            'id' => 1,
                        ],
                        [
                            'id' => 999,
                        ],
                        [
                            'id' => 2,
                        ],
                        [
                            'id' => 3,
                        ],
                    ],
                ],
                'expected'         => [
                    'id'   => 1,
                    'categories' => [
                        [
                            'id' => 1,
                            'title' => "Category title"
                        ],
                        [
                            'id' => 2,
                            'title' => "Category title"
                        ],
                        [
                            'id' => 3,
                            'title' => "Category title"
                        ],
                    ],
                ],
                'numberOfElements' => 3,
            ],
            [
                'entity'           => [
                    'id'   => 1,
                    'categories' => [
                        [
                            'id' => 1,
                        ],
                        [
                            'id' => 999,
                        ],
                        [
                            'id' => 2,
                        ],
                        [
                            'id' => 3,
                        ],
                    ],
                ],
                'expected'         => [
                    'id'   => 1,
                    'categories' => [
                        [
                            'id' => 1,
                            'title' => "Category title"
                        ],
                        [
                            'id' => 2,
                            'title' => "Category title"
                        ],
                        [
                            'id' => 3,
                            'title' => "Category title"
                        ],
                    ],
                ],
                'numberOfElements' => 5,
            ],
        ];
    }

    /**
     * @return CategoryApiService
     */
    private function getCategoryApiService()
    {
        return new CategoryApiService(new ApiClientStub("http://foo.com", "bar"));
    }
}