<?php

namespace Client\Services;

use Comitium5\ApiClientBundle\Client\Client;
use Comitium5\ApiClientBundle\Client\ClientInterface;
use Comitium5\ApiClientBundle\Client\Services\PagesApiService;
use Comitium5\ApiClientBundle\Tests\TestCase;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

class PagesApiServiceTest extends TestCase
{
    public function testShouldGetPageContent(): void
    {
        $id = 20;
        $expectedContent = [
            'id' => 1,
            'content' => 'foo',
        ];
        $client = $this->createMock(ClientInterface::class);
        $pagesApiService = new PagesApiService($client);

        $client
            ->expects($this->once())
            ->method('find')
            ->with('pages/content', $id)
            ->willReturn([
                'statusCode' => 200,
                'data' => $expectedContent,
            ]);

        $content = $pagesApiService->getContent(new IdentifiedValue($id));

        $this->assertEquals($expectedContent, $content);
    }

    public function testShouldGetDraftPageContent(): void
    {
        $id = 20;
        $draftId = 'foo-draft-id';
        $expectedContent = [
            'id' => $id,
            'draftId' => $draftId,
            'content' => 'foo',
        ];
        $client = $this->createMock(Client::class);
        $pagesApiService = new PagesApiService($client);

        $client
            ->expects($this->once())
            ->method('get')
            ->with('pages/content/20/draft/foo-draft-id')
            ->willReturn([
                'statusCode' => 200,
                'data' => $expectedContent,
            ]);

        $content = $pagesApiService->getDraftContent(new IdentifiedValue($id), $draftId);

        $this->assertEquals($expectedContent, $content);
    }

    public function testShouldGetCurrentDraftPageContent(): void
    {
        $id = 20;
        $draftId = 'foo-draft-id';
        $expectedContent = [
            'id' => $id,
            'draftId' => $draftId,
            'content' => 'foo',
        ];
        $client = $this->createMock(Client::class);
        $pagesApiService = new PagesApiService($client);

        $client
            ->expects($this->once())
            ->method('get')
            ->with('pages/content/20/draft')
            ->willReturn([
                'statusCode' => 200,
                'data' => $expectedContent,
            ]);

        $content = $pagesApiService->getDraftContent(new IdentifiedValue($id));

        $this->assertEquals($expectedContent, $content);
    }

    public function testShouldReturnNullWhenStatusCodeIsNot200(): void
    {
        $id = 30;
        $client = $this->createMock(ClientInterface::class);
        $pagesApiService = new PagesApiService($client);

        $client
            ->expects($this->once())
            ->method('find')
            ->with('pages/content', $id)
            ->willReturn([
                'statusCode' => 500,
                'data' => [],
            ]);

        $content = $pagesApiService->getContent(new IdentifiedValue($id));

        $this->assertEquals([], $content);
    }
}