<?php

namespace Client\Services;

use Comitium5\ApiClientBundle\Client\Services\CommentApiService;
use Comitium5\ApiClientBundle\Tests\Stubs\ApiClientStub;
use Comitium5\ApiClientBundle\Tests\Stubs\CommentApiClientStub;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;
use PHPUnit\Framework\TestCase;

class CommentApiServiceTest extends TestCase
{
    /**
     * @test
     * @dataProvider invalidParametersValue
     */
    public function testMultipleCountShouldReturnEmptyArrayWhenParametersAreEmpty(ParametersValue $value): void
    {
        $service = new CommentApiService(new ApiClientStub('fake-endpoint', 'fake-token'));

        $result = $service->multipleCount($value);

        $this->assertEmpty($result);
        $this->assertIsArray($result);
    }

    /**
     * @test
     */
    public function testMultipleCountShouldReturnCorrectValues(): void
    {
        $value = new ParametersValue([
            'contentType' => 'fake-contentType',
            'contentIds' => 'contentsWithComments'
        ]);
        $service = new CommentApiService(new CommentApiClientStub('fake-endpoint', 'fake-token'));
        $result = $service->multipleCount($value);

        $this->assertEquals($result['contentId-1'], 1);
        $this->assertEquals($result['contentId-2'], 4);
        $this->assertArrayNotHasKey('contentId-3', $result);
        $this->assertArrayNotHasKey('contentId-4', $result);
        $this->assertEquals($result['contentId-5'], 2);
    }

    /**
     * @test
     */
    public function testMultipleCountShouldReturnEmptyValues(): void
    {
        $value = new ParametersValue([
            'contentType' => 'fake-contentType',
            'contentIds' => 'contentsWithoutComments'
        ]);
        $service = new CommentApiService(new CommentApiClientStub('fake-endpoint', 'fake-token'));
        $result = $service->multipleCount($value);

        $this->assertEmpty($result);
    }

    public function invalidParametersValue(): array
    {
        return [
            [new ParametersValue([])],
            [new ParametersValue(['contentType' => ''])],
            [new ParametersValue(['contentIds' => ''])],
            [new ParametersValue(['contentType' => '', 'contentIds' => '',])],
            [new ParametersValue(['contentType' => 'foo', 'contentIds' => '',])],
            [new ParametersValue(['contentType' => '', 'contentIds' => 'foo',])],
        ];
    }
}