<?php

namespace Comitium5\ApiClientBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/extension.html#cookbook-bundles-extension-config-class}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();

        $rootNode = $treeBuilder->root('comitium5_api_client');

        $rootNode->children()
            ->scalarNode('public_key')->isRequired()->end()
            ->scalarNode('private_key')->isRequired()->end()
            ->scalarNode('endpoint')->isRequired()->end()
            ->scalarNode('version')->isRequired()->end()
            ->scalarNode('site')->isRequired()->end()
            ->scalarNode('subsite')->isRequired()->end()
            ->scalarNode('api_use_cache')->defaultValue(true)->end()
            ->scalarNode('api_cache_ttl')->defaultValue(-1)->end()
            ->variableNode('redis_host')->isRequired()->end()
            ->variableNode('redis_scheme')->isRequired()->end()
            ->variableNode('redis_port')->isRequired()->end()
            ->variableNode('redis_database')->isRequired()->end()
            ->variableNode('redis_password')->defaultValue(null)->end()
            ->scalarNode('defaultLocale')->isRequired()->end()
            ->scalarNode('v2_endpoint')->isRequired()->end()
            ->scalarNode('v2_token')->isRequired()->end()
            ->end();

        return $treeBuilder;
    }
}
