<?php

namespace Tests\Normalizers;

use Comitium5\ApiClientBundle\Client\Services\TagApiService;
use Comitium5\ApiClientBundle\Normalizer\TagsApiNormalizer;
use Comitium5\ApiClientBundle\Tests\Stubs\ApiClientStub;
use Comitium5\ApiClientBundle\Tests\TestCase;

/**
 * Class TagsApiNormalizerTest
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Tests\Normalizers
 */
class TagsApiNormalizerTest extends TestCase
{
    /**
     * @param $entity
     * @param $expected
     * @param $numberOfElements
     *
     * @test
     * @dataProvider getData
     *
     * @throws \Exception
     */
    public function normalize($entity, $expected, $numberOfElements)
    {
        $tagApiService = $this->getTagApiService();

        $tagApiNormalizer = new TagsApiNormalizer($tagApiService, $numberOfElements);

        $tagApiNormalizer->normalize($entity);

        $this->assertEquals($expected, $entity);
    }

    /**
     * @return array
     */
    public function getData()
    {
        return [
            // Behaviour: normal
            [
                'entity'           => [
                    'id'   => 1,
                    'tags' => [
                        [
                            'id' => 1,
                        ],
                        [
                            'id' => 2,
                        ],
                    ],
                ],
                'expected'         => [
                    'id'   => 1,
                    'tags' => [
                        [
                            'id' => 1,
                            'title' => "Tag title"
                        ],
                        [
                            'id' => 2,
                            'title' => "Tag title"
                        ],
                    ],
                ],
                'numberOfElements' => null,
            ],
            // Behaviour: with number of elements passed by argument
            [
                'entity'           => [
                    'id'   => 1,
                    'tags' => [
                        [
                            'id' => 1,
                        ],
                        [
                            'id' => 2,
                        ],
                    ],
                ],
                'expected'         => [
                    'id'   => 1,
                    'tags' => [
                        [
                            'id' => 1,
                            'title' => "Tag title"
                        ],
                    ],
                ],
                'numberOfElements' => 1,
            ],
            // Behaviour: with an empty result for id 999
            [
                'entity'           => [
                    'id'   => 1,
                    'tags' => [
                        [
                            'id' => 1,
                        ],
                        [
                            'id' => 2,
                        ],
                        [
                            'id' => 999,
                        ],
                    ],
                ],
                'expected'         => [
                    'id'   => 1,
                    'tags' => [
                        [
                            'id' => 1,
                            'title' => "Tag title"
                        ],
                        [
                            'id' => 2,
                            'title' => "Tag title"
                        ],
                    ],
                ],
                'numberOfElements' => null,
            ],
            // Behaviour: with an empty result for id 999 and number of elements set
            [
                'entity'           => [
                    'id'   => 1,
                    'tags' => [
                        [
                            'id' => 1,
                        ],
                        [
                            'id' => 999,
                        ],
                        [
                            'id' => 2,
                        ],
                        [
                            'id' => 3,
                        ],
                    ],
                ],
                'expected'         => [
                    'id'   => 1,
                    'tags' => [
                        [
                            'id' => 1,
                            'title' => "Tag title"
                        ],
                        [
                            'id' => 2,
                            'title' => "Tag title"
                        ],
                        [
                            'id' => 3,
                            'title' => "Tag title"
                        ],
                    ],
                ],
                'numberOfElements' => 3,
            ],
        ];
    }

    /**
     * @return TagApiService
     */
    private function getTagApiService()
    {
        return new TagApiService(new ApiClientStub("http://foo.com", "bar"));
    }
}