<?php

namespace Comitium5\ApiClientBundle\Client\Services;

use Comitium5\ApiClientBundle\Client\Client;
use Comitium5\ApiClientBundle\Utils\ResponseUtils;

/**
 * Class UserApiService
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\ApiClientBundle\Client\Services
 */
class UserApiService
{
    /**
     * @var Client
     */
    private $apiClient;

    /**
     * UserApiService constructor.
     *
     * @param Client $apiClient
     */
    public function __construct(Client $apiClient)
    {
        $this->apiClient = $apiClient;
    }

    /**
     * @param string $token
     *
     * @return array|mixed
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function fetchByToken(string $token)
    {
        $response = $this
            ->apiClient
            ->post("users/auth", [
                "token" => $token,
            ]);

        return $this->handleResponse($response);
    }

    /**
     * @param array $response
     * @return array|mixed
     */
    protected function handleResponse(array $response)
    {
        return ResponseUtils::isValidResponse($response) ? $response["data"] : [];
    }
}
