<?php

namespace Comitium5\ApiClientBundle\Provider;

use Comitium5\ApiClientBundle\ApiClient\ClientInterface;
use Comitium5\ApiClientBundle\Parser\ResponseParser;
use GuzzleHttp\Psr7\Response;

/**
 * Class ApiProvider
 *
 * @deprecated In favor to v2
 * @package Comitium5\ApiClientBundle\Provider
 */
class ApiProvider
{
    /**
     * @var ClientInterface
     */
    private $client;

    /**
     * @param ClientInterface $client
     */
    public function __construct(ClientInterface $client)
    {
        $this->client = $client;
    }

    /**
     * @param $type
     * @param $id
     * @return array
     * @throws \Exception
     */
    public function find($type, $id)
    {
        if (is_array($id)) {
            if (!isset($id["id"])) {
                throw new \Exception("Id should be an integer or an array with id key");
            }

            $id = $id["id"];
        }

        $response = $this->client->get("{type}/{id}", array(
            'type' => $type,
            'id'   => $id,
        ));

        if ($this->isSuccessful($response) && $this->isJSON($response)) {
            return ResponseParser::decodeResponse($response);
        }

        return [];
    }

    /**
     * @param $type
     * @param  array       $parameters
     * @return array
     */
    public function findBy($type, array $parameters = [])
    {
        $path = "{type}";
        $pathParams = array('type' => $type);

        if (array_key_exists('id', $parameters)) {
            $path .= "/{id}";
            $pathParams['id'] = $parameters['id'];
            unset($parameters['id']);
        } elseif (array_key_exists('slug', $parameters)) {
            $path .= "/{slug}";
            $pathParams['slug'] = $parameters['slug'];
            unset($parameters['slug']);
        }

        $response = $this->client->get($path, $pathParams, array(
            'query' => $parameters,
        ));

        if ($this->isSuccessful($response) && $this->isJSON($response)) {
            return ResponseParser::decodeResponse($response);
        }

        return [];
    }

    /**
     * @param $type
     * @param $id
     * @return mixed|void
     */
    public function remove($type, $id)
    {
        $response = $this->client->delete("{type}/{id}", [
            'type' => $type,
            'id' => $id,
        ]);

        if ($this->isSuccessful($response) && $this->isJSON($response)) {
            return \json_decode($response->getBody(), true);
        }

        return;
    }

    /**
     * @param $type
     * @param $parameters
     * @return array
     */
    public function removeBy($type, $parameters)
    {
        $path = "{type}";
        $pathParams = array('type' => $type);

        if (array_key_exists('id', $parameters)) {
            $path .= "/{id}";
            $pathParams['id'] = $parameters['id'];
            unset($parameters['id']);
        } elseif (array_key_exists('slug', $parameters)) {
            $path .= "/{slug}";
            $pathParams['slug'] = $parameters['slug'];
            unset($parameters['slug']);
        }

        $response = $this->client->delete($path, $pathParams, array(
            'query' => $parameters,
        ));

        if ($this->isSuccessful($response) && $this->isJSON($response)) {
            return ResponseParser::decodeResponse($response);
        }

        return [];
    }

    /**
     * @param  Response|ResponseDecorator $response
     * @return bool
     */
    public function isSuccessful($response)
    {
        return ($response->getStatusCode() >= 200 && $response->getStatusCode() < 300) || $response->getStatusCode() == 304;
    }

    /**
     * @param  Response|ResponseDecorator $response
     * @return bool
     */
    public function isJSON($response)
    {
        return 'application/json' == $response->getHeaderLine('Content-Type');
    }

    /**
     * {@inheritdoc}
     */
    public function call($method, $url, array $parameters = array(), array $requestConfig = array())
    {
        $response = $this->client->call($method, $url, $parameters, $requestConfig);

        return new ResponseDecorator($response);
    }

    /**
     * {@inheritdoc}
     */
    public function get($url, array $parameters = array(), array $requestConfig = array())
    {
        $response = $this->client->get($url, $parameters, $requestConfig);

        return new ResponseDecorator($response);
    }

    /**
     * {@inheritdoc}
     */
    public function put($url, array $parameters = array(), array $requestConfig = array())
    {
        $response = $this->client->put($url, $parameters, $requestConfig);

        return new ResponseDecorator($response);
    }

    /**
     * {@inheritdoc}
     */
    public function post($url, array $parameters = array(), array $requestConfig = array())
    {
        $response = $this->client->post($url, $parameters, $requestConfig);

        return new ResponseDecorator($response);
    }

    /**
     * {@inheritdoc}
     */
    public function patch($url, array $parameters = array(), array $requestConfig = array())
    {
        $response =  $this->client->patch($url, $parameters, $requestConfig);

        return new ResponseDecorator($response);
    }

    /**
     * {@inheritdoc}
     */
    public function delete($url, array $parameters = array(), array $requestConfig = array())
    {
        $response = $this->client->delete($url, $parameters, $requestConfig);

        return new ResponseDecorator($response);
    }

    /**
     * @param $code
     */
    public function setAcceptLanguage($code)
    {
        $this->client->setAcceptLanguage($code);
    }

    /**
     * @param $forceContent
     */
    public function setForceGetContent($forceContent)
    {
        $this->client->setForceGetContent($forceContent);
    }

    /**
     * @param boolean $useCache
     */
    public function useCache($useCache)
    {
        $this->client->setUseCache($useCache);
    }

    /**
     * @return ClientInterface
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * @param ClientInterface $client
     * @return $this
     */
    public function setClient($client)
    {
        $this->client = $client;

        return $this;
    }

    /**
     * @param array $options
     * @return ClientInterface
     */
    public function buildClient(array $options = [])
    {
        $endpoint = !empty($options["endpoint"]) ? $options["endpoint"] : $this->client->getEndPoint();
        $version  = !empty($options["version"]) ? $options["version"] : $this->client->getVersion();
        $site     = !empty($options["site"]) ? $options["site"] : $this->client->getSite();
        $subSite  = !empty($options["subsite"]) ? $options["subsite"] : $this->client->getSubSite();

        $this
            ->client
            ->buildClient($endpoint, $version, $site, $subSite);

        return $this->client;
    }
}
