<?php

namespace Comitium5\ApiClientBundle\Normalizer;

use Comitium5\ApiClientBundle\Factory\ClientFactory;
use Comitium5\ApiClientBundle\Utils\ResponseUtils;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class RelatedContentsMultiSubSiteApiNormalizer
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Normalizer
 */
class RelatedContentsMultiSubSiteApiNormalizer implements NormalizerInterface
{
    /**
     * @var ClientFactory
     */
    protected $factory;

    /**
     * RelatedContentsMultiSubSiteApiNormalizer constructor.
     *
     * @param ClientFactory $clientFactory
     */
    public function __construct(ClientFactory $clientFactory)
    {
        $this->factory = $clientFactory;
    }

    /**
     * @param array $entity
     *
     * @return array|mixed
     * @throws \GuzzleHttp\Exception\GuzzleException|\Exception
     */
    public function normalize(array &$entity)
    {
        if (empty($entity['relatedContent'])) {
            return $entity;
        }

        foreach ($entity['relatedContent'] as $key => &$relatedContent) {
            $fetchedEntity = $this->entity(
                $relatedContent["type"],
                new IdentifiedValue($relatedContent["id"]),
                $relatedContent["site"],
                $relatedContent['subsites'][0]['acronym'],
                $entity['locale']
            );

            if (empty($fetchedEntity)) {
                unset($entity["relatedContent"][$key]);

                continue;
            }

            $relatedContent["data"] = $fetchedEntity;
        }

        return $entity;
    }

    /**
     * @param $resourceType
     * @param IdentifiedValue $identifiedValue
     * @param $siteAcronym
     * @param $subSiteAcronym
     * @param $locale
     *
     * @return array
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    protected function entity(
        $resourceType,
        IdentifiedValue $identifiedValue,
        $siteAcronym,
        $subSiteAcronym,
        $locale
    ) {
        $client = $this
            ->factory
            ->createInstance(
                $siteAcronym,
                $subSiteAcronym,
                $locale
            );

        $response = $client->find($resourceType, $identifiedValue->getId());

        if ($this->isValidResponse($response)) {
            return $response['data'];
        }

        return [];
    }

    /**
     * @param array $response
     *
     * @return bool
     */
    protected function isValidResponse(array $response)
    {
        return ResponseUtils::isValidResponse($response);
    }
}
