<?php

namespace Comitium5\ApiClientBundle\Client\Services;

use Comitium5\ApiClientBundle\ApiClient\ResourcesTypes;
use Comitium5\ApiClientBundle\Client\ClientInterface;
use Comitium5\ApiClientBundle\Utils\ResponseUtils;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;

/**
 * Class ContactSubscriptionApiService
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\ApiClientBundle\Client\Services
 */
class ContactSubscriptionApiService
{
    /**
     * @var ClientInterface
     */
    protected $apiClient;

    /**
     * AbstractApiService constructor.
     *
     * @param ClientInterface $apiClient
     */
    public function __construct(ClientInterface $apiClient)
    {
        $this->apiClient = $apiClient;
    }

    /**
     * @param ParametersValue $parametersValue
     *
     * @return array
     */
    public function post(ParametersValue $parametersValue): array
    {
        $response = $this
            ->apiClient
            ->create(
                ResourcesTypes::CONTACT_SUBSCRIPTION,
                $parametersValue->getOptions()
            );

        return ResponseUtils::handleResponse($response);
    }
}
