<?php

namespace Comitium5\ApiClientBundle\Client;

use Comitium5\ApiClientBundle\Normalizer\RequestParametersNormalizer\RequestParametersNormalizerInterface;

/**
 * Interface ClientInterface
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\ApiClientBundle\Client
 */
interface ClientInterface
{
    const HEADER_AUTH     = "Authorization";
    const HEADER_SITE     = "CS-SITE";
    const HEADER_SUB_SITE = "CS-SUBSITE";
    const HEADER_LANGUAGE = "CS-LANGUAGE";
    const HEADER_FORCE_CONTENT = "CS-FORCE-CONTENT";

    /**
     * @param $site
     * @param $subSite
     * @param $locale
     * @param null $token
     * @return mixed
     */
    public function buildClient($site, $subSite, $locale, $token = null);

    /**
     * @param $resourceType
     * @param $id
     * @return mixed
     */
    public function find($resourceType, $id);

    /**
     * @param $resourceType
     * @param array|RequestParametersNormalizerInterface $parameters
     * @return mixed
     */
    public function findBy($resourceType, $parameters);

    /**
     * @param $resourceType
     * @param array|RequestParametersNormalizerInterface $parameters
     * @return mixed
     */
    public function create($resourceType, $parameters);

    /**
     * @param $resourceType
     * @param array|RequestParametersNormalizerInterface $parameters
     * @return mixed
     */
    public function update($resourceType, $id, $parameters);

    /**
     * @param $resourceType
     * @param $id
     * @return mixed
     */
    public function remove($resourceType, $id);
}