<?php

namespace Comitium5\ApiClientBundle\ValueObject\Product;

use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class ProductObject
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package ValueObject\Product
 */
abstract class ProductObject
{
    /**
     * @var IdentifiedValue
     */
    protected $identifiedValue;

    /**
     * ProductObject constructor.
     *
     * @param IdentifiedValue $identifiedValue
     */
    public function __construct(IdentifiedValue $identifiedValue)
    {
        $this->identifiedValue = $identifiedValue;
    }

    /**
     * @return string
     */
    abstract public function getResourceType();

    /**
     * @return IdentifiedValue
     */
    public function getIdentifiedValue()
    {
        return $this->identifiedValue;
    }
}
