<?php

namespace Comitium5\ApiClientBundle\Tests\Client\Services;

use Comitium5\ApiClientBundle\Client\Services\ArticleApiService;
use Comitium5\ApiClientBundle\Tests\TestCase;
use Comitium5\ApiClientBundle\Tests\Stubs\ApiClientStub;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;

class ArticleServiceTest extends TestCase
{
    /**
     * @test
     * @throws \Exception
     */
    public function find()
    {
        $service = new ArticleApiService(new ApiClientStub("http://api.mock.com", "ABDCFGHY"));
        $article = $service->find(new IdentifiedValue(2));

        $this->assertEquals($article["id"], 2);
    }

    /**
     * @test
     * @throws \Exception
     */
    public function findBy()
    {
        $service = new ArticleApiService(new ApiClientStub("http://api.mock.com", "ABDCFGHY"));
        $articles = $service->findBy(new ParametersValue(["limit" => 3]));

        $this->assertEquals(count($articles["results"]), 3);
    }
}