<?php

namespace Comitium5\ApiClientBundle\Normalizer\RequestParametersNormalizer;

use Comitium5\ApiClientBundle\ValueObject\FileValue;

/**
 * Class GuzzleMultipartParametersNormalizer
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\ApiClientBundle\Normalizer\RequestParametersNormalizer
 */
class GuzzleMultipartParametersNormalizer implements RequestParametersNormalizerInterface
{

    /**
     * @var array
     */
    protected $parameters;

    /**
     * @var array
     */
    protected $normalizedParameters;

    /**
     * @var array
     */
    protected $fileValues;

    /**
     * GuzzleMultipartParametersNormalizer constructor.
     *
     * @param array $parameters
     * @param array $fileValues
     *
     * @throws \ErrorException
     */
    public function __construct(array $parameters, array $fileValues = [])
    {
        $this->parameters = $parameters;
        $this->fileValues = $fileValues;

        $this->resolveParameters();
        $this->resolveFileValues();
    }

    /**
     * @return array
     */
    public function normalize()
    {
        return [
            'multipart' => $this->normalizedParameters,
        ];
    }

    /**
     * @throws \ErrorException
     */
    public function resolveFileValues()
    {
        try {
            foreach ($this->fileValues as $fileValue) {
                /** @var $fileValue FileValue */
                $this->normalizeFileFields(
                    $fileValue->getPaths(),
                    $fileValue->getFieldName()
                );
            }
        } catch (\Exception $exception) {
            throw new \ErrorException("The path received is not valid, please try again");
        }
    }

    /**
     * @param array $paths
     * @param $fieldName
     *
     * @return array
     */
    public function normalizeFileFields(array $paths, $fieldName)
    {
        foreach ($paths as $path) {
            $this->normalizedParameters[] = [
                'name'     => $fieldName,
                'contents' => fopen($path, 'r'),
            ];
        }
    }

    /**
     * @return array
     */
    public function resolveParameters()
    {
        $fileValueParamters = [];

        foreach ($this->parameters as $key => $value) {
            $this->normalizedParameters[] = [
                'name'     => $key,
                'contents' => $value,
            ];
        }

        return $fileValueParamters;
    }

}