<?php

namespace Comitium5\ApiClientBundle\Tests\Normalizers;

use Comitium5\ApiClientBundle\Client\Client;
use Comitium5\ApiClientBundle\Factory\ClientFactory;
use Comitium5\ApiClientBundle\Normalizer\RelatedContentsMultiSubSiteApiNormalizer;
use Comitium5\ApiClientBundle\Tests\TestCase;

/**
 * Class RelatedContentsMultiSubSiteApiNormalizerTest
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Tests\Normalizers
 */
class RelatedContentsMultiSubSiteApiNormalizerTest extends TestCase
{
    /**
     * @dataProvider normalizeData
     *
     * @param array $entity
     *
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function testNormalize(array $entity)
    {
        $normalizer = new RelatedContentsMultiSubSiteApiNormalizer(
            $this->factory()
        );

        $normalizedEntity = $normalizer->normalize($entity);

        $this->assertGreaterThan(0, count($normalizedEntity['relatedContent']));

        foreach ($normalizedEntity['relatedContent'] as $relatedContent) {
            $this->assertNotEmpty($relatedContent['data']);
        }
    }

    /**
     * @return array
     */
    public function normalizeData()
    {
        return [
            [
                [
                    "id"              => 1,
                    "relatedContent" => [
                        [
                            "type"     => "articles",
                            "id"       => 10,
                            "subsites" => [
                                [
                                    "acronym" => "subsite1",
                                ],
                            ],
                            "site" => "site1",
                        ],
                        [
                            "type"     => "categories",
                            "id"       => 11,
                            "subsites" => [
                                [
                                    "acronym" => "subsite2",
                                ],
                            ],
                            "site" => "site1",
                        ],
                    ],
                ],
            ],
        ];
    }

    /**
     * @return \PHPUnit_Framework_MockObject_MockObject
     */
    private function factory()
    {
        $clientMock = $this->createMock(Client::class);
        $clientMock
            ->method('find')
            ->willReturn([
                "statusCode" => 200,
                "data" => [
                    "title" => "title1"
                ],
            ]);

        $mock = $this->createMock(ClientFactory::class);

        $mock
            ->method("createInstance")
            ->willReturn($clientMock);

        return $mock;
    }
}
