<?php

namespace Comitium5\ApiClientBundle\Tests\Normalizers;

use Comitium5\ApiClientBundle\Client\Services\ArticleApiService;
use Comitium5\ApiClientBundle\Client\Services\AssetApiService;
use Comitium5\ApiClientBundle\Normalizer\ApiNormalizator;
use Comitium5\ApiClientBundle\Normalizer\RelatedContentsApiNormalizer;
use Comitium5\ApiClientBundle\Tests\Stubs\ApiClientStub;
use Comitium5\ApiClientBundle\Tests\TestCase;

/**
 * Class RelatedContentApiNormalizerTest
 * @package Comitium5\ApiClientBundle\Tests\Normalizers
 */
class RelatedContentApiNormalizerTest extends TestCase
{
    /**
     * @test
     */
    public function normalizerFirst()
    {
        $normalizator = new ApiNormalizator([new RelatedContentsApiNormalizer($this->services())]);

        $entity = [
            "id"             => 1,
            "relatedContent" => [
                [
                    "type" => "foo",
                    "id"   => 1,
                ],
                [
                    "type" => "articles",
                    "id"   => 1,
                ],
                [
                    "type" => "assets",
                    "id"   => 1,
                ],
            ],
            "assets"         => [
                ["id" => 1],
                ["id" => 2],
            ],
        ];

        $expectedEntity = [
            "id"             => 1,
            "assets"         => [
                ["id" => 1],
                ["id" => 2],
            ],
            "relatedContent" => [
                [
                    "type" => "articles",
                    "id"   => 1,
                    "data" => [
                        "id"    => 1,
                        "title" => "Article title",
                    ],
                ],
                [
                    "type" => "assets",
                    "id"   => 1,
                    "data" => [
                        "id"    => 1,
                        "src" => "/foo/bar.png"
                    ],
                ],
            ],
        ];

        $normalized = $normalizator->normalize($entity);

        $this->assertEquals($expectedEntity, $normalized);

        $entity = [
            "id"             => 1,
            "relatedContent" => [
                [
                    "type" => "foo",
                    "id"   => 1,
                ],
                [
                    "type" => "articles",
                    "id"   => 2,
                ],
                [
                    "type" => "articles",
                    "id"   => 999,
                ],
                [
                    "type" => "articles",
                    "id"   => 1,
                ],
            ],
            "assets"         => [
                ["id" => 1],
                ["id" => 2],
            ],
        ];

        $expectedEntity = [
            "id"             => 1,
            "assets"         => [
                ["id" => 1],
                ["id" => 2],
            ],
            "relatedContent" => [
                [
                    "type" => "articles",
                    "id"   => 2,
                    "data" => [
                        "id"    => 2,
                        "title" => "Article title",
                    ],
                ],
                [
                    "type" => "articles",
                    "id"   => 1,
                    "data" => [
                        "id"    => 1,
                        "title" => "Article title",
                    ],
                ],
            ],
        ];

        $normalized = $normalizator->normalize($entity);

        $this->assertEquals($expectedEntity, $normalized);
    }

    /**
     * @return array
     */
    private function services()
    {
        return [
            "assets"   => new AssetApiService(new ApiClientStub("http://foo.com", "xxxx")),
            "articles" => new ArticleApiService(new ApiClientStub("http://foo.com", "xxxx")),
        ];
    }
}
