<?php

namespace Comitium5\ApiClientBundle\Normalizer;

use Comitium5\ApiClientBundle\Client\Services\CategoryApiService;
use Comitium5\ApiClientBundle\Client\Services\TagApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class TagsApiNormalizer
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\ApiClientBundle\Normalizer
 */
class TagsApiNormalizer implements NormalizerInterface
{
    /**
     * @var CategoryApiService
     */
    private $entityService;

    /**
     * @var int|null
     */
    private $numberOfElements;

    /**
     * TagsApiNormalizer constructor.
     *
     * @param TagApiService $entityService
     * @param null $numberOfElements
     */
    public function __construct(TagApiService $entityService, $numberOfElements = null)
    {
        $this->entityService = $entityService;
        $this->numberOfElements = $numberOfElements;
    }

    /**
     * @param array $entity
     *
     * @return array|mixed
     * @throws \Exception
     */
    public function normalize(array &$entity)
    {
        $normalizedTags = [];

        $i = 0;

        foreach ($entity['tags'] as $tag) {
            $tag = $this->entity(new IdentifiedValue($tag['id']));

            if (empty($tag)) {
                continue;
            }

            $normalizedTags[] = $tag;

            $i++;

            if ($this->numberOfElements !== null && $i >= $this->numberOfElements) {
                break;
            }
        }

        $entity['tags'] = $normalizedTags;

        return $entity;
    }

    /**
     * @param IdentifiedValue $identifiedValue
     *
     * @return array|mixed
     * @throws \Exception
     */
    protected function entity(IdentifiedValue $identifiedValue)
    {
        return $this
            ->entityService
            ->find($identifiedValue);
    }
}
