<?php

namespace Tests\Utils;

use Comitium5\ApiClientBundle\Tests\TestCase;
use Comitium5\ApiClientBundle\Utils\ResponseUtils;

/**
 * Class ResponseUtilsTest
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Tests\Utils
 */
class ResponseUtilsTest extends TestCase
{
    /**
     * @dataProvider isValidResponseData
     * @param array $response
     * @param $expected
     */
    public function testIsValidResponse(array $response, $expected)
    {
        $this->assertEquals(
            $expected,
            ResponseUtils::isValidResponse($response)
        );
    }

    /**
     * @return array
     */
    public function isValidResponseData()
    {
        return [
            [
                ["statusCode" => 200],
                true
            ],
            [
                ["statusCode" => 299],
                true
            ],
            [
                ["statusCode" => 199],
                false
            ],
            [
                ["statusCode" => 300],
                false
            ],
        ];
    }
}
