<?php

namespace Comitium5\ApiClientBundle\ValueObject;

/**
 * Class IdentifiedValue
 * @package ValueObject
 */
class IdentifiedValue
{
    /**
     * @var integer
     */
    private $id;

    /**
     * IdentifiedValue constructor.
     * @param $id
     * @throws \Exception
     */
    public function __construct($id)
    {
        if (!is_numeric($id)) {
            throw new \Exception("Id value must be numeric");
        }

        $id = intval($id);

        if ($id <= 0) {
            throw new \Exception("Id value must be grater than 0");
        }

        $this->id = intval($id);
    }

    public function getId()
    {
        return $this->id;
    }
}