<?php

namespace Comitium5\ApiClientBundle\Client\Services;

use Comitium5\ApiClientBundle\ApiClient\ResourcesTypes;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class ContactApiService
 * @package Comitium5\ApiClientBundle\Client\Services
 */
class ContactApiService extends AbstractApiService implements ApiServiceMutationInterface
{
    /**
     * @param IdentifiedValue $identifiedValue
     * @return array|mixed
     * @throws \Exception
     */
    public function find(IdentifiedValue $identifiedValue)
    {
        $response = $this->fetch(
            $identifiedValue,
            ResourcesTypes::CONTACT
        );

        return $this->handleResponse($response);
    }

    /**
     * @param ParametersValue $parametersValue
     * @return array
     * @throws \Exception
     */
    public function findBy(ParametersValue $parametersValue)
    {
        $response = $this->fetchBy(
            $parametersValue,
            ResourcesTypes::CONTACT
        );

        return $this->handleResponse($response);
    }

    /**
     * @param ParametersValue $parametersValue
     * @return array
     * @throws \Exception
     */
    public function post(ParametersValue $parametersValue)
    {
        $response = $this->create(
            $parametersValue,
            ResourcesTypes::CONTACT
        );

        return $this->handleResponse($response);
    }

    /**
     * @param IdentifiedValue $identifiedValue
     * @param ParametersValue $parametersValue
     * @return array
     * @throws \Exception
     */
    public function put(IdentifiedValue $identifiedValue, ParametersValue $parametersValue)
    {
        $response = $this->update(
            $identifiedValue,
            $parametersValue,
            ResourcesTypes::CONTACT
        );

        return $this->handleResponse($response);
    }
}