<?php

namespace Comitium5\ApiClientBundle\Normalizer;

use Comitium5\ApiClientBundle\Client\Services\AuthorApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class AuthorApiNormalizer
 * @package Comitium5\ApiClientBundle\Normalizer
 */
class AuthorApiNormalizer implements NormalizerInterface
{
    /**
     * @var AuthorApiService
     */
    private $entityService;

    /**
     * AuthorNormalizer constructor.
     *
     * @param AuthorApiService $entityService
     */
    public function __construct (AuthorApiService $entityService)
    {
        $this->entityService = $entityService;
    }

    /**
     * @param array $entity
     *
     * @return array|mixed
     * @throws \Exception
     */
    public function normalize (array &$entity)
    {
        if (!empty($entity['author']['id'])) {
            $entity['author'] = $this->entity(new IdentifiedValue($entity['author']['id']));
        }

        return $entity;
    }

    /**
     * @param IdentifiedValue $identifiedValue
     * @return array|mixed
     * @throws \Exception
     */
    protected function entity (IdentifiedValue $identifiedValue)
    {
        return $this
            ->entityService
            ->find($identifiedValue);
    }
}